EvaluateSystemScript("wintro.js");

// Create images object
images = new Object();

EvaluateScript("animation.js");
EvaluateScript("battle.js");
EvaluateScript("character.js");
EvaluateScript("effects.js");
EvaluateScript("enemy.js");
EvaluateScript("font.js");
EvaluateScript("system.js");
EvaluateScript("item.js");
EvaluateScript("layout.js");
EvaluateScript("map.js");
EvaluateScript("menu.js");
EvaluateScript("window.js");

var Damizean = new Character("Damizean");
Damizean.hp = 1245;
Damizean.hpmax = 1373;
Damizean.mp = 245;
Damizean.mpmax = 250;
Damizean.strength = 38;
Damizean.attack = 16;
Damizean.agility = 12
Damizean.lv = 6;
Damizean.hit = 90;
Damizean.weapon = BigBlade;

var tEffect = new Effect(Damizean);
tEffect.addSprite(0, 0, "fx_boom", "boom", 1);

var Annika = new Character("Annika");
Annika.hp = 604;
Annika.hpmax = 1033;
Annika.mp = 324;
Annika.mpmax = 343;
Annika.strength = 23;
Annika.attack = 12;
Annika.agility = 16;
Annika.lv = 6;
Annika.hit = 90;
Annika.weapon = BigBlade;

var Lazaerin = new Character("Lazaerin");
Lazaerin.hp = 600;
Lazaerin.hpmax = 600;
Lazaerin.mp = 403;
Lazaerin.mpmax = 403;
Lazaerin.strength = 20;
Lazaerin.agility = 15;
Lazaerin.lv = 6;
Lazaerin.hit = 90;
Lazaerin.weapon = BigBlade;

var Richt = new Character("Richt");
Richt.hp = 1400;
Richt.hpmax = 1400;
Richt.mp = 108;
Richt.mpmax = 154;
Richt.strength = 38;
Richt.attack = 16;
Richt.agility = 10;
Richt.lv = 6;
Richt.hit = 90;
Richt.weapon = BigBlade;

var log = OpenLog("log.txt");

function game()
{
	//Introduction();
	//mainMenu();
	newGame();
}

function Introduction()
{
	var intro = new introObject("None", "Title.rfn");
	intro.endColor = CreateColor(255, 255, 255);
	intro.addText("(c) 2002", 0, 200, 500, 320, 200);
	intro.addImage("NNG_Logo_white.png", 3000);
	intro.addText("Presents...", 160, 120, 4000);
	intro.addImage("logo.png", 2000, 160, 120, 5000);
	intro.addText("Fallacious", 160, 66, 500, 160, 66);
	intro.addText("Gear", 200, 124, 100, 200, 124);
	intro.addText("Are", 60, 40, 4000, 160, 200);
	intro.addText("You", 40, 200, 300, 280, 40);
	intro.addText("Ready?", 160, 120, 300);
	intro.play();
}

function mainMenu()
{
	var logo = LoadImage("title.png");
	var menu = new menuObject();
	menu.heading = "MAIN";
	menu.addItem("New Game");
	menu.addItem("Load Game");
	menu.addItem("Exit");
	var selection = undefined;
	while (selection == undefined)
	{
		ApplyColorMask(colors.white);
		logo.blit(160 - logo.width / 2, 0);
		menu.draw(120, 190, 3);
		FlipScreen();
		selection = menu.control(120, 180, 3);
	}
	switch (selection)
	{
		case 0:
			newGame();
			break;
		case 1:
			loadGame();
			break;
		case 2:
			exitGame();
			break;
	}
}

function newGame()
{
	InitiateGame();
	CreatePerson("Player", "Damizean.rss", true);
	AttachInput("Player");
	AttachCamera("Player");
	MapEngine("Overworld.rmp", 60);
}

function loadGame()
{
}

function exitGame()
{
}